/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.snippets.DocumentSnippetTemplateContext;
import com.aptana.editor.common.scripting.snippets.SnippetTemplate;
import com.aptana.editor.common.scripting.snippets.SnippetTemplateContextType;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.SnippetElement;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.TemplateBuffer;

public class SnippetTemplateUtil {
    public static String evaluateSnippet(SnippetElement snippet, IDocument document, Position position) {
        String expansion = snippet.getExpansion();
        SnippetTemplate template = new SnippetTemplate((CommandElement)snippet, expansion);
        String scope = snippet.getScope();
        if (scope != null) {
            SnippetTemplateContextType contextType = new SnippetTemplateContextType(scope);
            DocumentSnippetTemplateContext context = new DocumentSnippetTemplateContext(contextType, document, position);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                if (buffer != null) {
                    return buffer.getString();
                }
            }
            catch (Exception e) {
                IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Error in template {0}. {1}", snippet.getDisplayName(), e.getMessage()), (String)"com.aptana.editor.common/debug/presentation");
            }
        }
        return expansion;
    }
}

